# SafeMarket Guard Admin Panel - PHP

## Setup Instructions

### 1. Database Setup

1. Create a MySQL database named `safemarket_guard`
2. Import the database schema:

```bash
mysql -u root -p safemarket_guard < admin/includes/database.sql
```

Or import via phpMyAdmin by opening `admin/includes/database.sql` and executing the SQL.

### 2. Configure Database Connection

Edit `admin/includes/config.php` and update the database credentials:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'safemarket_guard');
define('DB_USER', 'root');      // Your MySQL username
define('DB_PASS', '');          // Your MySQL password
```

### 3. Configure Site URL

Update the `SITE_URL` in `admin/includes/config.php` to match your domain:

```php
define('SITE_URL', 'http://localhost/Safety%20Monitoring%20App/admin');
```

### 4. Default Admin Login

- **Email:** admin@safemarket.com
- **Password:** admin123

### 5. Google Maps API (Optional)

To enable the live map feature:

1. Get a Google Maps API key from https://console.cloud.google.com/
2. Enable the "Maps JavaScript API"
3. Edit `admin/includes/header.php` and replace `YOUR_API_KEY` with your actual key:

```html
<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_ACTUAL_API_KEY&libraries=places"></script>
```

### 6. File Structure

```
admin/
├── includes/
│   ├── config.php       # Database configuration
│   ├── database.sql    # Database schema
│   ├── header.php      # Common header template
│   └── footer.php      # Common footer template
├── api/
│   ├── activity.php    # Activity notifications API
│   ├── sos.php         # SOS alerts API
│   ├── locations.php   # Location data API
│   └── export.php      # Data export API
├── index.php           # Dashboard/Overview
├── map.php            # Live tracking map
├── staff.php          # Staff management
├── checkins.php       # Photo evidence/check-ins
├── sos.php            # SOS alerts management
├── reports.php        # Reports & analytics
├── login.php          # Login page
├── logout.php         # Logout handler
└── .htaccess          # URL routing
```

### 7. Running the Application

- **Using XAMPP/WAMP:** Place the project in `htdocs` folder
- **Using PHP Built-in Server:**

```bash
cd admin
php -S localhost:8000
```

Then access: http://localhost:8000

### Features

1. **Dashboard Overview** - Real-time stats, charts, recent activity
2. **Live Map** - Track staff locations on Google Maps
3. **Staff Management** - Add, edit, remove guards
4. **Check-ins/Photo Evidence** - View and verify photo check-ins
5. **SOS Alerts** - Monitor and respond to emergency alerts
6. **Reports** - Export data in CSV/JSON formats

### Security Notes

- Change the default admin password after first login
- Update `SESSION_SECRET_KEY` in production
- Enable HTTPS in production
- Update database credentials with strong passwords
