<?php
/**
 * API Endpoint for SOS Alerts
 * Returns SOS alert data and handles actions
 */

require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();
    $action = $_GET['action'] ?? 'list';
    
    switch ($action) {
        case 'count':
            // Get active SOS count
            $count = $pdo->query("SELECT COUNT(*) FROM sos_alerts WHERE status = 'active'")->fetchColumn();
            echo json_encode(['success' => true, 'count' => (int)$count]);
            break;
            
        case 'list':
            // Get all SOS alerts
            $status = $_GET['status'] ?? '';
            
            $query = "
                SELECT s.*, u.name as user_name, u.phone as user_phone
                FROM sos_alerts s
                JOIN users u ON s.user_id = u.id
            ";
            
            if ($status) {
                $query .= " WHERE s.status = ?";
                $stmt = $pdo->prepare($query);
                $stmt->execute([$status]);
            } else {
                $stmt = $pdo->query($query);
            }
            
            $alerts = $stmt->fetchAll();
            echo json_encode(['success' => true, 'data' => $alerts]);
            break;
            
        case 'active':
            // Get only active SOS alerts
            $stmt = $pdo->query("
                SELECT s.*, u.name as user_name, u.phone as user_phone
                FROM sos_alerts s
                JOIN users u ON s.user_id = u.id
                WHERE s.status = 'active'
                ORDER BY s.created_at DESC
            ");
            $alerts = $stmt->fetchAll();
            echo json_encode(['success' => true, 'data' => $alerts]);
            break;
            
        case 'update':
            // Update SOS status (admin action)
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $id = (int)$_POST['id'];
                $status = sanitize($_POST['status']);
                $notes = sanitize($_POST['notes'] ?? '');
                
                $admin = getCurrentAdmin();
                
                $query = "UPDATE sos_alerts SET status = ?, ";
                $params = [$status];
                
                if (in_array($status, ['resolved', 'false_alarm'])) {
                    $query .= "resolved_by = ?, resolved_at = NOW(), ";
                    $params[] = $admin['id'];
                }
                
                $query .= "description = CONCAT(IFNULL(description, ''), ?) ";
                $params[] = "\n[" . strtoupper($status) . "] " . $notes;
                
                $query .= "WHERE id = ?";
                $params[] = $id;
                
                $stmt = $pdo->prepare($query);
                $stmt->execute($params);
                
                echo json_encode(['success' => true, 'message' => 'SOS alert updated']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Invalid request method']);
            }
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
