<?php
/**
 * Database Configuration for Tressa Marketers Location Admin
 * 
 * Update these values to match your database settings
 */

define('DB_HOST', 'localhost');
define('DB_NAME', 'safemarket_guard');
define('DB_USER', 'root');
define('DB_PASS', '');

define('SITE_URL', 'http://localhost/Safety%20Monitoring%20App/admin');
define('ADMIN_EMAIL', 'admin@tressamarketerslocation.com');

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 0); // Set to 1 in production with HTTPS
ini_set('session.use_strict_mode', 1);

session_start();

// Timezone
date_default_timezone_set('Africa/Lagos');

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

/**
 * Database Connection
 */
function getDBConnection() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            error_log("Database connection error: " . $e->getMessage());
            die("Database connection failed. Please check configuration.");
        }
    }
    
    return $pdo;
}

/**
 * Check if admin is logged in
 */
function isLoggedIn() {
    return isset($_SESSION['admin_id']) && !empty($_SESSION['admin_id']);
}

/**
 * Redirect to login page
 */
function redirectToLogin() {
    header('Location: login.php');
    exit;
}

/**
 * Require login to access page
 */
function requireLogin() {
    if (!isLoggedIn()) {
        redirectToLogin();
    }
}

/**
 * Sanitize input
 */
function sanitize($input) {
    if (is_array($input)) {
        return array_map('sanitize', $input);
    }
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

/**
 * Get current admin user info
 */
function getCurrentAdmin() {
    if (!isLoggedIn()) {
        return null;
    }
    
    return [
        'id' => $_SESSION['admin_id'],
        'name' => $_SESSION['admin_name'] ?? 'Admin',
        'email' => $_SESSION['admin_email'] ?? ''
    ];
}

/**
 * Log admin action
 */
function logAdminAction($action, $details = '') {
    $pdo = getDBConnection();
    $adminId = $_SESSION['admin_id'] ?? 0;
    
    $stmt = $pdo->prepare("INSERT INTO admin_logs (admin_id, action, details, ip_address, created_at) VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$adminId, $action, $details, $_SERVER['REMOTE_ADDR'] ?? '']);
}
