<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>Tressa Marketers Location - Admin Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: '#fc8100',
                        'primary-dark': '#c96800',
                        'background-light': '#f6f6f8',
                        'background-dark': '#121320',
                        'status-safe': '#22c55e',
                        'status-warning': '#f59e0b',
                        'status-danger': '#ef4444',
                        'status-offline': '#94a3b8'
                    },
                    fontFamily: {
                        display: ['Inter', 'sans-serif']
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .sidebar {
            transition: all 0.3s;
        }
        .sidebar a {
            transition: all 0.2s;
        }
        .sidebar a:hover, .sidebar a.active {
            background-color: rgba(255, 255, 255, 0.1);
        }
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body class="bg-background-light">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <aside class="w-64 bg-primary text-white flex flex-col fixed h-full">
            <div class="p-6">
                <div class="flex items-center gap-3">
                    <img src="../app/src/main/res/drawable/logo3.png" alt="Logo" class="w-8 h-8 object-contain">
                    <span class="text-xl font-bold">Tressa Marketers Location</span>
                </div>
                <p class="text-xs text-blue-200 mt-1">Admin Dashboard</p>
            </div>

            <nav class="flex-1 px-4">
                <a href="index.php" class="flex items-center gap-3 px-4 py-3 rounded-lg <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-th-large"></i>
                    <span>Overview</span>
                </a>
                <a href="map.php" class="flex items-center gap-3 px-4 py-3 rounded-lg mt-2 <?php echo basename($_SERVER['PHP_SELF']) == 'map.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>Live Map</span>
                </a>
                <a href="staff.php" class="flex items-center gap-3 px-4 py-3 rounded-lg mt-2 <?php echo basename($_SERVER['PHP_SELF']) == 'staff.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-users"></i>
                    <span>Staff</span>
                </a>
                <a href="checkins.php" class="flex items-center gap-3 px-4 py-3 rounded-lg mt-2 <?php echo basename($_SERVER['PHP_SELF']) == 'checkins.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-camera"></i>
                    <span>Check-ins</span>
                </a>
                <a href="sos.php" class="flex items-center gap-3 px-4 py-3 rounded-lg mt-2 <?php echo basename($_SERVER['PHP_SELF']) == 'sos.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-exclamation-triangle text-status-danger"></i>
                    <span>SOS Alerts</span>
                    <?php 
                    require_once 'config.php';
                    $pdo = getDBConnection();
                    $sosCount = $pdo->query("SELECT COUNT(*) FROM sos_alerts WHERE status = 'active'")->fetchColumn();
                    if($sosCount > 0): ?>
                    <span class="ml-auto bg-status-danger text-xs px-2 py-1 rounded-full"><?php echo $sosCount; ?></span>
                    <?php endif; ?>
                </a>
                <a href="reports.php" class="flex items-center gap-3 px-4 py-3 rounded-lg mt-2 <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'bg-white/10' : ''; ?>">
                    <i class="fas fa-chart-bar"></i>
                    <span>Reports</span>
                </a>
            </nav>

            <div class="p-4 border-t border-white/10">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-medium"><?php echo htmlspecialchars($admin['name'] ?? 'Admin'); ?></p>
                        <p class="text-xs text-blue-200"><?php echo htmlspecialchars($admin['email'] ?? 'admin@tressamarketerslocation.com'); ?></p>
                    </div>
                    <a href="logout.php" class="text-white/70 hover:text-white" title="Logout">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 ml-64 overflow-y-auto">
            <!-- Header -->
            <header class="bg-white shadow-sm px-8 py-4 flex items-center justify-between sticky top-0 z-10">
                <h1 class="text-2xl font-bold text-gray-800"><?php echo $pageTitle ?? 'Dashboard'; ?></h1>
                <div class="flex items-center gap-4">
                    <button class="p-2 text-gray-500 hover:text-primary relative" onclick="loadNotifications()">
                        <i class="fas fa-bell text-xl"></i>
                        <?php if($sosCount > 0): ?>
                        <span class="absolute top-0 right-0 w-2 h-2 bg-status-danger rounded-full"></span>
                        <?php endif; ?>
                    </button>
                    <a href="logout.php" class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark">
                        <i class="fas fa-sign-out-alt mr-2"></i>Logout
                    </a>
                </div>
            </header>

            <!-- Content -->
            <div class="p-8">
